/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.mapui.dialog;

import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.mapui.resources.VWResource;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class VWNewMapDialog
extends VWModalDialog
implements ActionListener,
DocumentListener {
    private static final Dimension DIM_DIALOG_SIZE = new Dimension(440, 275);
    public static final int STATUS_OK = 0;
    public static final int STATUS_CANCEL = 1;
    public static final int STATUS_HELP = 2;
    public static final int MAPTYPE_SUBMAP = 0;
    public static final int MAPTYPE_PARENTMAP = 1;
    private GridBagConstraints m_gbCons = null;
    private VWToolbarBorder m_mapTypeBorder = null;
    private JRadioButton m_newMapRadioButton = null;
    private JRadioButton m_overrideInheritedMapRadioButton = null;
    private VWToolbarBorder m_nameBorder = null;
    private JTextField m_newMapTextField = null;
    private JComboBox m_parentMapsComboBox = null;
    private VWToolbarBorder m_descriptionBorder = null;
    private JTextArea m_description = null;
    private JButton m_okButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;
    private int m_nStatus = 1;
    private int m_nMapType = 0;
    private VWWorkflowDefinition m_wfDefinition = null;
    private VWWorkflowDefinition m_parentWfDefinition = null;

    public VWNewMapDialog(Frame parentFrame, VWWorkflowDefinition wfDef, VWWorkflowDefinition baseWfDef) {
        super(parentFrame);
        this.m_wfDefinition = wfDef;
        this.m_parentWfDefinition = baseWfDef;
        this.init();
    }

    public String getMapName() {
        switch (this.m_nMapType) {
            case 0: {
                return this.m_newMapTextField.getText();
            }
            case 1: {
                return (String)this.m_parentMapsComboBox.getSelectedItem();
            }
        }
        return null;
    }

    public String getMapDescription() {
        return this.m_description.getText();
    }

    public int getStatus() {
        return this.m_nStatus;
    }

    public int getMapType() {
        return this.m_nMapType;
    }

    public VWMapDefinition getSelectedParentMap() {
        VWMapDefinition map = null;
        try {
            if (this.m_parentWfDefinition != null) {
                map = this.m_parentWfDefinition.getMap((String)this.m_parentMapsComboBox.getSelectedItem());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return map;
    }

    public void actionPerformed(ActionEvent event) {
        try {
            Object source = event.getSource();
            if (source == this.m_cancelButton) {
                this.performCancel();
            } else if (source == this.m_okButton) {
                this.performOK();
            } else if (source == this.m_helpButton) {
                this.performHelp();
            } else if (source == this.m_newMapRadioButton) {
                this.m_okButton.setEnabled(this.m_newMapTextField.getText().length() > 0);
                this.m_newMapTextField.setVisible(true);
                this.m_newMapTextField.requestFocus();
                this.m_parentMapsComboBox.setVisible(false);
                this.m_nMapType = 0;
            } else if (source == this.m_overrideInheritedMapRadioButton) {
                this.m_okButton.setEnabled(true);
                this.m_newMapTextField.setVisible(false);
                this.m_parentMapsComboBox.setVisible(true);
                this.m_parentMapsComboBox.requestFocus();
                this.m_nMapType = 1;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void changedUpdate(DocumentEvent e) {
        this.m_okButton.setEnabled(this.m_newMapTextField.getText().length() > 0);
    }

    public void insertUpdate(DocumentEvent e) {
        this.m_okButton.setEnabled(this.m_newMapTextField.getText().length() > 0);
    }

    public void removeUpdate(DocumentEvent e) {
        this.m_okButton.setEnabled(this.m_newMapTextField.getText().length() > 0);
    }

    private void init() {
        try {
            this.getContentPane().setLayout(new GridBagLayout());
            this.m_gbCons = new GridBagConstraints();
            this.setTitle(VWResource.s_createSubmap);
            this.setSize(DIM_DIALOG_SIZE);
            if (this.m_parentWfDefinition != null) {
                this.initMapTypeRadioButtons();
            }
            this.initNameControls();
            this.initDescriptionControls();
            this.initDialogButtons();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void initMapTypeRadioButtons() {
        try {
            this.m_mapTypeBorder = new VWToolbarBorder(VWResource.s_mapTypeStr);
            JPanel clientPanel = this.m_mapTypeBorder.getClientPanel();
            clientPanel.setLayout(new GridBagLayout());
            ButtonGroup mapTypeGroup = new ButtonGroup();
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 19;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.fill = 2;
            gbCons.weightx = 0.5;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(0, 0, 0, 0);
            this.m_newMapRadioButton = new JRadioButton(VWResource.s_newMapStr);
            this.m_newMapRadioButton.setSelected(true);
            this.m_newMapRadioButton.addActionListener(this);
            mapTypeGroup.add(this.m_newMapRadioButton);
            clientPanel.add((Component)this.m_newMapRadioButton, gbCons);
            ++gbCons.gridx;
            this.m_overrideInheritedMapRadioButton = new JRadioButton(VWResource.s_overrideInheritedMap);
            this.m_overrideInheritedMapRadioButton.setSelected(false);
            this.m_overrideInheritedMapRadioButton.addActionListener(this);
            mapTypeGroup.add(this.m_overrideInheritedMapRadioButton);
            clientPanel.add((Component)this.m_overrideInheritedMapRadioButton, gbCons);
            this.m_gbCons.anchor = 23;
            this.m_gbCons.fill = 2;
            this.m_gbCons.gridx = 0;
            this.m_gbCons.gridy = 0;
            this.m_gbCons.gridheight = 1;
            this.m_gbCons.gridwidth = 1;
            this.m_gbCons.weightx = 1.0;
            this.m_gbCons.weighty = 0.0;
            this.m_gbCons.insets = new Insets(2, 2, 2, 2);
            this.getContentPane().add((Component)this.m_mapTypeBorder, this.m_gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void initNameControls() {
        JPanel clientPanel = null;
        try {
            this.m_gbCons.anchor = 23;
            this.m_gbCons.fill = 2;
            this.m_gbCons.gridx = 0;
            this.m_gbCons.gridy = 1;
            this.m_gbCons.gridheight = 1;
            this.m_gbCons.gridwidth = 1;
            this.m_gbCons.weightx = 1.0;
            this.m_gbCons.weighty = 0.0;
            this.m_gbCons.insets = new Insets(2, 2, 2, 2);
            this.m_nameBorder = new VWToolbarBorder(VWResource.s_nameStr);
            clientPanel = this.m_nameBorder.getClientPanel();
            clientPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.fill = 2;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(0, 0, 0, 0);
            this.m_newMapTextField = new JTextField();
            this.m_newMapTextField.setName("m_newMapTextField_VWNewMapDialog");
            this.m_newMapTextField.setVisible(true);
            this.m_newMapTextField.getDocument().addDocumentListener(this);
            clientPanel.add((Component)this.m_newMapTextField, gbCons);
            if (this.m_parentWfDefinition != null) {
                this.m_parentMapsComboBox = new JComboBox();
                this.m_parentMapsComboBox.setRenderer(new VWLabelListCellRenderer());
                this.m_parentMapsComboBox.setName("m_parentMapsComboBox_VWNewMapDialog");
                this.m_parentMapsComboBox.setVisible(false);
                this.initParentMapsComboBox();
                if (this.m_parentMapsComboBox.getModel().getSize() == 0) {
                    this.m_overrideInheritedMapRadioButton.setEnabled(false);
                }
                clientPanel.add((Component)this.m_parentMapsComboBox, gbCons);
            }
            this.getContentPane().add((Component)this.m_nameBorder, this.m_gbCons);
            this.m_newMapTextField.requestDefaultFocus();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void initDescriptionControls() {
        try {
            this.m_descriptionBorder = new VWToolbarBorder(VWResource.s_descriptionStr);
            JPanel clientPanel = this.m_descriptionBorder.getClientPanel();
            clientPanel.setLayout(new BorderLayout());
            this.m_description = new JTextArea();
            this.m_description.setName("m_description_VWNewMapDialog");
            clientPanel.add(new JScrollPane(this.m_description));
            this.m_gbCons.anchor = 23;
            this.m_gbCons.fill = 1;
            this.m_gbCons.gridx = 0;
            this.m_gbCons.gridy = 2;
            this.m_gbCons.gridheight = 1;
            this.m_gbCons.gridwidth = 1;
            this.m_gbCons.weightx = 1.0;
            this.m_gbCons.weighty = 1.0;
            this.m_gbCons.insets = new Insets(2, 2, 2, 2);
            this.getContentPane().add((Component)this.m_descriptionBorder, this.m_gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void initDialogButtons() {
        try {
            JPanel clientPanel = new JPanel();
            clientPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 10;
            gbCons.fill = 0;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.weightx = 0.3;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(0, 0, 0, 5);
            this.m_okButton = new JButton(VWResource.s_ok);
            this.m_okButton.setName("m_okButton_VWNewMapDialog");
            this.m_okButton.addActionListener(this);
            this.m_okButton.setEnabled(false);
            clientPanel.add((Component)this.m_okButton, gbCons);
            ++gbCons.gridx;
            this.m_cancelButton = new JButton(VWResource.s_cancel);
            this.m_cancelButton.setName("m_cancelButton_VWNewMapDialog");
            this.m_cancelButton.addActionListener(this);
            clientPanel.add((Component)this.m_cancelButton, gbCons);
            ++gbCons.gridx;
            gbCons.insets = new Insets(0, 0, 0, 0);
            this.m_helpButton = new JButton(VWResource.s_help);
            this.m_helpButton.setName("m_helpButton_VWNewMapDialog");
            this.m_helpButton.addActionListener(this);
            clientPanel.add((Component)this.m_helpButton, gbCons);
            this.m_gbCons.anchor = 10;
            this.m_gbCons.fill = 0;
            this.m_gbCons.gridx = 0;
            this.m_gbCons.gridy = 3;
            this.m_gbCons.gridheight = 1;
            this.m_gbCons.gridwidth = 1;
            this.m_gbCons.weightx = 1.0;
            this.m_gbCons.weighty = 0.0;
            this.m_gbCons.insets = new Insets(8, 2, 8, 2);
            this.getContentPane().add((Component)clientPanel, this.m_gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void initParentMapsComboBox() {
        block5: {
            try {
                Object[] maps;
                if (this.m_wfDefinition == null || this.m_parentWfDefinition == null || (maps = this.m_parentWfDefinition.getMaps()) == null || maps.length <= 0) break block5;
                VWQubbleSort.sort(maps);
                this.m_parentMapsComboBox.removeAllItems();
                this.m_parentMapsComboBox.removeActionListener(this);
                for (int i = 0; i < maps.length; ++i) {
                    VWMapDefinition currentWorkflowMap = null;
                    String mapName = ((VWMapDefinition)maps[i]).getName();
                    try {
                        currentWorkflowMap = this.m_wfDefinition.getMap(mapName);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    if (currentWorkflowMap != null) continue;
                    this.m_parentMapsComboBox.addItem(mapName);
                }
                this.m_parentMapsComboBox.addActionListener(this);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }

    private void performOK() {
        this.m_nStatus = 0;
        this.setVisible(false);
    }

    private void performCancel() {
        this.m_nStatus = 1;
        this.setVisible(false);
    }

    private void performHelp() {
        VWHelp.displayPage(VWHelp.Help_Process_Designer + "bpfdh150.htm");
    }
}

